#ifndef _COMMON_H_
#define _COMMON_H_

#include <vector>
#include <string>
#include <map>
#include <iostream>
#include <ctime>
#include <list>
#include <cmath>
#include <cstring>

using namespace std;

#ifdef    _MSC_VER
	#define isfinite    _finite
#endif

#define FEAT_ID (unsigned long)
#define POSI	(unsigned int)

namespace dparser {
	/** Type of a float value. */
	typedef double floatval_t;

	extern const double LOG_EXP_ZERO;

	extern const double EPS;
	extern const double ZERO;
	extern const double DOUBLE_NEGATIVE_INFINITY;
	extern const double DOUBLE_POSITIVE_INFINITY;

	extern const size_t RIGHT;
	extern const size_t LEFT;
	extern const size_t CMP;
	extern const size_t INCMP;
	extern const size_t SIB_SP;
	extern const size_t HEAD;
	extern const size_t CHILD;

	extern const string OOV_STR;

	extern const string NO_FORM;
	extern const string NO_LEMMA;
	extern const string NO_CPOSTAG;
	extern const string NO_POSTAG;
	extern const string NO_FEAT;
	extern const string NO_DEPREL;
	extern const int	NO_HEAD;

	extern const string FEAT_SEP;

	// remove the blanks at the begin and end of string
	inline void clean_str(string &str) 
	{
		string blank = " \t\r\n";
		string::size_type pos1 = str.find_first_not_of(blank);
		string::size_type pos2 = str.find_last_not_of(blank);
		if (pos1 == string::npos) {
			str = "";
		} else {
			str = str.substr(pos1, pos2-pos1+1);
		}
	}

	inline void print_time() {
#ifdef SHOW_TIME
		time_t lt=time(NULL);
		string strTime = ctime(&lt);
		clean_str(strTime);
		std::cerr << "\t[" << strTime << "]" << endl;
#endif
	}

	inline bool smaller_than(const double a, const double b) {
		return (a < b - EPS);
	}
	inline bool bigger_than(const double a, const double b) {
		return (a > b + EPS);
	}
	inline bool coarse_equal_to(const double a, const double b) {
        const double interval = 1e-3;
		return ( (a <= b+interval) && (a >= b-interval));
	}
	inline bool equal_to(const double a, const double b) {
		return ( (a <= b+EPS) && (a >= b-EPS));
	}
	inline bool equal_to_negative_infinite(const double a) {
		return equal_to(a, DOUBLE_NEGATIVE_INFINITY);
	}

    inline double abs(const double val) { return (val > 0 ? val : -val); }

	void get_children( const vector<int> &heads, vector< list<int> > &children_l, vector< list<int> > &children_r );



	class ValueIndexPair {
	public:
		double val;
		int i1, i2;
	public:
		ValueIndexPair(double _val=0, int _i1=0, int _i2=0) : val(_val), i1(_i1), i2(_i2) {}

		int compareTo(const ValueIndexPair &other) const {
			if(val < other.val - EPS)
				return -1;
			if(val > other.val + EPS)
				return 1;
			return 0;
		}

		ValueIndexPair &operator=(const ValueIndexPair &other) {
			val = other.val; i1 = other.i1; i2 = other.i2; return *this;
		}
	};

	// Max Heap
	// We know that never more than K elements on Heap
	class BinaryHeap { 

	public:
		bool empty() {
			return currentSize == 0;
		}

		BinaryHeap(int def_cap) {
			DEFAULT_CAPACITY = def_cap;
			theArray.resize(DEFAULT_CAPACITY+1); 
			// theArray[0] serves as dummy parent for root (who is at 1) 
			// "largest" is guaranteed to be larger than all keys in heap
			theArray[0] = ValueIndexPair(DOUBLE_POSITIVE_INFINITY,-1,-1);      
			currentSize = 0; 
		} 

		BinaryHeap() {} 

		BinaryHeap &resize(int new_size) {
			DEFAULT_CAPACITY = new_size;
			theArray.resize(DEFAULT_CAPACITY+1); 
			theArray[0] = ValueIndexPair(DOUBLE_POSITIVE_INFINITY,-1,-1);      
			currentSize = 0;
			return *this;
		}

		//ValueIndexPair getMax() {
		//	return theArray[1]; 
		//}


		void add(const ValueIndexPair &e) { 
			//if (currentSize == DEFAULT_CAPACITY) {	// reach the max size
			//
			//}
			// bubble up: 
			int where = currentSize + 1; // new last place 
			while ( e.compareTo(theArray[parent(where)]) > 0 ){ 
				theArray[where] = theArray[parent(where)]; 
				where = parent(where); 
			} 
			theArray[where] = e; currentSize++;
		}

		void removeMax(ValueIndexPair &max);

	private:
		int parent(int i) { return i / 2; } 
		int getLeftChild(int i) { return 2 * i; } 
		int getRightChild(int i) { return 2 * i + 1; } 

	private:
		int DEFAULT_CAPACITY; 
		int currentSize; 
		vector<ValueIndexPair> theArray;
	};

	inline static void veczero(floatval_t *x, const int n)
	{
		memset(x, 0, sizeof(floatval_t) * n);
	}

	inline static void vecset(floatval_t *x, const floatval_t a, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			x[i] = a;
		}
	}

	inline static void veccopy(floatval_t *y, const floatval_t *x, const int n)
	{
		memcpy(y, x, sizeof(floatval_t) * n);
	}

	inline static void vecadd(floatval_t *y, const floatval_t *x, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] += x[i];
		}
	}

	inline static void vecaadd(floatval_t *y, const floatval_t a, const floatval_t *x, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] += a * x[i];
		}
	}

	inline static void vecsub(floatval_t *y, const floatval_t *x, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] -= x[i];
		}
	}

	inline static void vecasub(floatval_t *y, const floatval_t a, const floatval_t *x, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] -= a * x[i];
		}
	}

	inline static void vecmul(floatval_t *y, const floatval_t *x, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] *= x[i];
		}
	}

	inline static void vecinv(floatval_t *y, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] = 1. / y[i];
		}
	}

	inline static void vecscale(floatval_t *y, const floatval_t a, const int n)
	{
		int i;
		for (i = 0;i < n;++i) {
			y[i] *= a;
		}
	}

	inline static floatval_t vecdot(const floatval_t *x, const floatval_t *y, const int n)
	{
		int i;
		floatval_t s = 0;
		for (i = 0;i < n;++i) {
			s += x[i] * y[i];
		}
		return s;
	}

	inline static floatval_t vecsum(floatval_t* x, const int n)
	{
		int i;
		floatval_t s = 0.;

		for (i = 0;i < n;++i) {
			s += x[i];
		}
		return s;
	}

	inline static floatval_t vecsumlog(floatval_t* x, const int n)
	{
		int i;
		floatval_t s = 0.;
		for (i = 0;i < n;++i) {
			s += log(x[i]);
		}
		return s;
	}
}

#endif



