#ifndef _INSTANCE_
#define _INSTANCE_

#pragma once

#include <string>
#include <vector>
#include <fstream>
#include <iostream>
#include <algorithm>

#include "Parameters.h"
#include "FVec.h"
#include "NRMat.h"
using namespace nr;
using namespace std;
using namespace egstra;

namespace dparser {

	class Instance
	{
	public:
		Instance(const int _id) : id(_id) {}
		~Instance() {}
		int size() const { return forms.size(); }

	public:
		const int id;

		NRMat< fvec > fvec_unigram;			// [N+1, T]
		NRMat< double > prob_unigram;
		NRMat3d< fvec > fvec_bigram;		// [N+1 T T]
		NRMat3d< double > prob_bigram; 

	public:
		vector<int>		predicted_pos_ids;
		vector<string>	predicted_postags;
		sparsevec		predicted_fv;
		double			predicted_prob;

		vector<string> forms;
		vector<string> lemmas;
		vector<string> cpostags;
		vector<string> postags;
		vector<string> orig_feats;
		vector<int> heads;
		vector<string> deprels;
		vector<string> pheads;
		vector<string> pdeprels;
		
		vector< vector<string> > chars;
		vector<string> contain_hyphen;
		vector<string> contain_number;
		vector<string> contain_uppercase_char;

		// during training, ambiguous labelings
		NRMat<bool> constrained_tags;
		vector< vector<string> > constrained_tags_str;
		
		// during test, filter tags and probs
		vector< vector<string> > filtered_tags;
		vector< vector<int> > filtered_tags_id;
		vector< vector<double> > prob_filtered_tags;
		
		vector<string> guide_postags;
		vector<double> guide_probs;

		/* data structure for lexicon feature*/
		NRVec<string> fbegin_vec;
		NRVec<string> fmiddle_vec;
		NRVec<string> fend_vec;
	};

} // namespace dparser


#endif



