#include <stdio.h>
#include <assert.h>
#include <iostream>

#include "Parameters.h"

#define myname "Parameters"

using namespace std;

namespace egstra {

	parameters::parameters(const int dim)
		: _dim(dim), _W(NULL), _scale(1.)
	{	
		realloc(_dim);
	}

	parameters::~parameters() { dealloc(); }


	void parameters::dealloc() {
		if (_W) delete [] _W;
	}

	void parameters::realloc(const int dim) {
		dealloc();
		_dim = dim;

		if(dim > 0) {
			_W = new double[_dim];
			assert(_W != NULL);
			zero();
		} else {
			_W = NULL;
		}
	}

	void parameters::save(const string& dir, const int t,
		const string& stem) const {
			char* const fname = new char[dir.size() + 64 + stem.size()];
			sprintf(fname, "%s/%s.%04d.gz", dir.c_str(), stem.c_str(), t);
/*			char* const command = new char[64 + stem.size() + dir.size()];

			sprintf(command, "gzip -c > '%s/%s'", dir.c_str(), fname);
			cerr << myname << " : writing to \""
				<< dir << "/" << fname << "\" " << flush;

			FILE* gzout = popen(command, "w");
            while (gzout == NULL) {
                cerr << "error popen: " << command << endl;
                cerr << "sleep for 60 seconds..." << endl;
                sleep(60);
			    gzout = popen(command, "w");
            }
*/
            cerr << "\nsave parameters to \"" << fname << "\" " << endl;

            FILE *gzout = fopen(fname, "w");
            assert(gzout != NULL);
			fprintf(gzout, "%d\n", _dim); 

			delete [] fname;

			const double * const p = _W;
			/* only print nonzero parameters */
			int nnz = 0;
			for (int i = 0; i < _dim; ++i) {
				if(p[i] >= dparser::ZERO || p[i] <= -dparser::ZERO) {
					fprintf(gzout, "%d %.16g\n", i, p[i]);
					if(((++nnz) & 0xfffff) == 0) { cerr << "." << flush; }
				}
			}

			/* assert(pclose(gzout) != -1); */
			fclose(gzout);
			cerr << "\nparameters::save [nnz=" << nnz << "/" << _dim << "]" << endl;
	}

	void parameters::delete_file(const string& dir, const int t,
		const string& stem) {
#ifndef _WIN32
			char* const cmd = new char[dir.size() + 64 + stem.size()];
			sprintf(cmd, "rm %s/%s.%04d.gz", dir.c_str(), stem.c_str(), t);
            system(cmd);
#endif
    }

	void parameters::load(const string& dir, const int t,
		const string& stem) {
			char* const fname = new char[dir.size() + 64 + stem.size()];
			sprintf(fname, "%s/%s.%04d.gz", dir.c_str(), stem.c_str(), t);
/*			char* const command = new char[64 + stem.size() + dir.size()];
			sprintf(command, "gunzip -c '%s/%s'", dir.c_str(), fname);

			FILE* gzin = popen(command, "r");
            while (gzin == NULL) {
                cerr << "error popen: " << command << endl;
                cerr << "sleep for 60 seconds..." << endl;
                sleep(60);
			    gzin = popen(command, "r");
            }*/

			cerr << myname << " : reading from \""
				<< fname << "\" " << flush;

            FILE *gzin = fopen(fname, "r");
			assert(gzin != NULL);

			int tmp;
			assert(fscanf(gzin, "%d\n", &tmp) == 1);
			assert(tmp > 0);
			_dim = tmp;
			realloc(_dim);

			delete [] fname;

			double * const p = _W;
			/* the parameters file can omit zero values, so we need to read
			lines on-demand */
			int index = -1;
			double value = 0;
			int nnz = 0;
			while(1) {
				const int nread = fscanf(gzin, "%d %lf\n", &index, &value);
				if(nread <= 0 && feof(gzin)) { break; }
				assert(nread == 2);
				assert(index >= 0);
				assert(index < _dim);
				p[index] = value;
				if(((++nnz) & 0xfffff) == 0) { cerr << "." << flush; }
			}

			/* assert(pclose(gzin) != -1); */
			fclose(gzin);
			cerr << " [nnz=" << nnz << "/" << _dim << "]" << endl;
	}
}

#undef myname


