#ifndef _INSTANCE_
#define _INSTANCE_

#pragma once

#include <string>
#include <vector>
#include <fstream>
#include <iostream>
#include <algorithm>

#include "Parameters.h"
#include "FVec.h"
#include "NRMat.h"
using namespace nr;
using namespace std;
using namespace egstra;

namespace dparser {

	class Instance
	{
	public:
		Instance(const int _id) : id(_id) {}
		~Instance() {}
		int size() const { return forms.size(); }

	public:
		const int id;
		NRVec< fvec > fvec_unigram_base;	// [N+1]

		NRMat< fvec > fvec_bigram_base_joint;	// [N+1, T]   T=TA*TB (coupled tags)
		NRMat< fvec > fvec_bigram_base_a;		// [N+1, TA]
		NRMat< fvec > fvec_bigram_base_b;		// [N+1, TB]

		NRMat< fvec > fvec_unigram_joint;		// [N+1, T]
		NRMat< double > prob_unigram_joint;
		NRMat3d< fvec > fvec_bigram_joint;		// [N+1 T T]
		NRMat3d< double > prob_bigram_joint;

		NRMat< fvec > fvec_unigram_a;		// [N+1, TA]
		NRMat< double > prob_unigram_a;
		NRMat3d< fvec > fvec_bigram_a;		// [N+1 TA TA]
		NRMat3d< double > prob_bigram_a; 

		NRMat< fvec > fvec_unigram_b;		// [N+1, TB]
		NRMat< double > prob_unigram_b;
		NRMat3d< fvec > fvec_bigram_b;		// [N+1 TB TB]
		NRMat3d< double > prob_bigram_b; 

	public:
		vector<int>	predicted_tagids;

		//vector<string>	predicted_tags_b;
		//vector<string>	predicted_tags_a;
		vector<string>	predicted_tags_joint;

		sparsevec		predicted_fv;
		double			predicted_prob;

		vector<string> forms;
		vector<string> lemmas;
		vector<string> cpostags;
		vector<string> postags;
		vector<string> orig_feats;
		vector<int> heads;
		vector<string> deprels;
		vector<string> pheads;
		vector<string> pdeprels;
		
		// during training, ambiguous labelings
		NRMat<bool> constrained_tags;
		vector< vector<string> > constrained_tags_str;
		
		// during test, filter tags and probs
		vector< vector<string> > filtered_tags;
		vector< vector<double> > filtered_probs;
		
		// lexicon feature, created by chaojy
		NRVec<string> fbegin_vec;
		NRVec<string> fmiddle_vec;
		NRVec<string> fend_vec;
	};

} // namespace dparser


#endif



